
import os
from B01Common import CommonSql
from E01CommonVolumes import CommonVolumes
from shapely.wkt import loads
from shapely.geometry import shape, mapping

class AddColumnPR(CommonSql):
    def __init__(self,pgconn):
        CommonSql.__init__(self,pgconn)

    def execute_query(self):
        query='''SELECT vol_id FROM airspace_volume;'''
        try: 
            self._cursor.execute(query)
            results=self._cursor.fetchall()
           
        except Exception as ex :
            print("ERROR: ", type(ex), ex.args)
        
        for vol in results:
            self.add_pr_to_volume(vol[0])

    def add_pr_to_volume(self,vol_id):
        [point,radious]=self.add_PR(vol_id)
        query_insert=''' UPDATE airspace_volume SET geom_center=ST_GeomFromText(ST_AsEWKT(ST_GeomFromText('{}',4326)::geography)), geom_radius={} WHERE vol_id='{}';'''.format(point,radious,vol_id)
        
        try:
            self._cursor.execute(query_insert)
            self._pgconn.connection.commit()
        except Exception as ex :
            print("ERROR: ", type(ex), ex.args)

    def add_PR(self,vol_id):
        collection={}
        collection['type']='GeometryCollection'
        geometries=[]
        

        query_vol='''SELECT geom_origin, ST_AsText(geom_buffer) FROM airspace_volume WHERE vol_id='{}'; '''.format(vol_id)

        try: 
            self._cursor.execute(query_vol)
            results=self._cursor.fetchall()
            geom_origin_id=results[0][0]
            geom_buffer=loads(results[0][1])
           
        except Exception as ex :
            print("ERROR: ", type(ex), ex.args)

        if geom_origin_id==None:
            geom=mapping(geom_buffer.centroid)
            geometries.append(geom)
            radious='Null'
        else:

            query_feature='''SELECT ST_AsText(geom_point), ST_AsText(geom_polygon), ST_AsText(geom_center), ST_AsText(geom_linestring) FROM features WHERE feature_id='{}';'''.format(geom_origin_id)
            try: 
                self._cursor.execute(query_feature)
                results=self._cursor.fetchall()
                geom_point=results[0][0]
                geom_polygon=results[0][1]
                geom_center=results[0][2]
                geom_linestring=results[0][3]
            except Exception as ex :
                print("ERROR: ", type(ex), ex.args)
            
            if geom_point!=None or geom_linestring!=None:
                query='''SELECT geofence_basic_layers.buffer 
                        FROM features, layers_cartography, geofence_basic_layers
                        WHERE
                        features.feature_id='{}' AND
                        geofence_basic_layers.name=layers_cartography.name AND
                        layers_cartography.layer_id=features.layers_layer_id;'''.format(geom_origin_id)
                try:
                    self._cursor.execute(query)
                    results=self._cursor.fetchall()
                    radious=results[0][0]
                except Exception as ex :
                    print('ERROR IN ORIGIN')
                    print("ERROR: ", type(ex), ex.args)
            
                if geom_point!=None:
                    geom= mapping(loads(geom_point))
                    print(geom)
                    geometries.append(geom)
                    
                elif geom_linestring!=None:
                    geom= mapping(loads(geom_linestring))
                    print(geom)
                    geometries.append(geom)
                    radious=-radious
                
            elif geom_polygon!=None:
                geom= mapping(loads(geom_center))
                print(geom)
                geometries.append(geom)
                radious='Null'
            else:
                print('ERROR NO GEOMETRY')
            
        collection['geometries']=geometries 
        point=shape(collection)   

        return [point,radious]


