from B01Common import CommonSql
from E01CommonVolumes import CommonVolumes
from A03VolumeFeature import FillVolumeFeature
import datetime
import os

class BasicLayersVolumes(CommonSql):
    def __init__(self,pgconn):
        CommonSql.__init__(self,pgconn)


    def createquerys(self):
        #get number of features in basic layers
        cm=CommonVolumes(self._pgconn)
        
        n_layers= cm.query_numberlayers()
        range_id=range(1,n_layers+1)
        #range_id=[3] #if you only want to create some of the layers
        for id_f in range_id:
            layer_info=cm.getinfogeofence(id_f)
            if layer_info=='error':
                print('Not possible to get information from this layer')
            else:
                name=layer_info[0]
                geofence= layer_info[1]
                buffer= layer_info[2]
                code_zone_reason=layer_info[3]
                code_uspace_class_type=layer_info[4]

                if geofence==True:
                    Volume=FillVolumeFeature(self._pgconn)
                    Volume.Create_volume_layer(name, buffer, code_zone_reason,code_uspace_class_type)


    
    

