from pgConnection import PgConnection
from A03VolumeFeature import FillVolumeFeature
from A04AddVolumesBasicLayers import BasicLayersVolumes
from A05AddVolumesAeronautics import AeronauticsVolumes
from E01CommonVolumes import CommonVolumes
from A07CheckDuplication import Duplication
from A08AddPR import AddColumnPR
from A06CreateProceduresPy import CreateProceduresPy
from A09GeofenceALL import Geofence_ALLR
import os
import datetime
import time

#0. CONECTION:
database="utm"
pgconn = PgConnection(database)

execCase=5
#1. CREATION OF VOLUMES BASIC LAYERS:
if(execCase==1):
    Volume= BasicLayersVolumes(pgconn)
    Volume.createquerys()
    print('volumes from basic layers created')

#2. CREATE VOLUMES FROM AERONAUTIC CARTOGRAPHY:
if(execCase==2):
    AeroVol=AeronauticsVolumes(pgconn)
    AeroVol.CreateAeronauticsVolumes()
    print('aeronautic cartography volumes inserted')

#3. CREATION OF VOLUME FROM A SPECIFIC LAYER:
if(execCase==3):
    VolumeFeature = FillVolumeFeature(pgconn)
    name='aerodromes'
    buffer=8000
    code_zone=1
    code_uspace=1
    VolumeFeature.Create_volume_layer(name, buffer,code_zone,code_uspace)
    print('copy layer 1')

#4. NEW GEOFENCE WITH ALL TYPE OF RESTRICTIONS:
if(execCase==4):
    new_G= Geofence_ALLR(pgconn)
    new_G.create_geofence()

#5. CHECK DUPLICATE GEOMETRIES:
if(execCase==5):
    dup=Duplication(pgconn)
    name_tables=[['protected_zone_volume','natural_zone_volume'],['military_volume'],['hospitals_volume'],['schools_volume'],['townhall_volume'],
    ['aerodromes_volume'],['rail_station_volume'],['power_plant_volume']] # 'sensitive', 'ControlledAirspace' ??
    for tables in name_tables:
        print(tables)
        dup.check_duplication(tables)
        print('end')

