from A03Functionalities import Functionality 
from C01Common import CommonSql
from random import randint

class Basic_layers_Download(CommonSql):
    def __init__(self,pgconn):
        CommonSql.__init__(self,pgconn)

    def query(self, download_type, coords):
        #get number of features in basic layers
        n_layers= self.query_numberlayers()
    
        #for each:
            #get feature from table -> id
            #get all the types and subtypes with this feature id 
            #execute one_subtype
        vec_total=range(3, n_layers+1)

        for id_f in vec_total:
            print("start id layer",id_f)
            info= self.query_getInform(id_f)
            if info!=0: 
                func= Functionality(self._pgconn)
 
                #get the different types and subtypes for this feature:
                osm_types= self.get_osmtype(id_f)
                #for each type and subtype
                for types in osm_types:
                    class_osm=types[0]
                    doc=types[2]
                    if types[1]!= 'all':
                        subclass_osm=types[1]
                        try:
                            func.one_subtype_osm(doc, class_osm, subclass_osm, download_type,coords)
                        except Exception as ex :
                            #we have to take into account what can we do when the required query in osm is too higher -> #one option comunidades autonomas
                            print("ERROR: ", type(ex), ex.args)
                    else:
                        try:
                            func.one_group_osm(doc, class_osm, download_type,coords)
                        except Exception as ex :
                            #we have to take into account what can we do when the required query in osm is too higher -> #one option comunidades autonomas
                            print("ERROR: ", type(ex), ex.args)
                

        

    def query_numberlayers(self):

        query=''' SELECT feature_id FROM geofence_basic_layers;'''

        try:
            self._cursor.execute(query)
            layers= self._cursor.fetchall()
            return len(layers)
        except:
            return 0

    def query_getInform(self,id_f):

        query=''' SELECT name, geometry_codification_geometry_type, geofence, buffer, prop1, prop2, description_layer
                  FROM geofence_basic_layers 
                  WHERE feature_id={};'''.format(id_f)

        try:
            self._cursor.execute(query)
            info= self._cursor.fetchall()
            return info[0]

        except Exception as ex :
            print("ERROR: ", type(ex), ex.args)
            return 0

    def get_osmtype(self,id_f):

        query= '''SELECT class_osm, subclass_osm, document_name FROM osm_basic_layers WHERE geofence_basic_layers_feature_id='{}';'''.format(id_f)

        try:
            self._cursor.execute(query)
            osmtypes= self._cursor.fetchall()
            return osmtypes
        except Exception as ex :
            print("ERROR: ", type(ex), ex.args)
            return 0
    
    
        
    
            


