import overpy
import geojson

def get_geojson(q, name_file):
    features =[]
    for relation in q.relations:
        print('relation:', relation.id)
        coordenadas_outer = []
        coordenadas_inners = []
        for elemento in relation.members:
            if elemento._type_value == "way":  # puede haber tambíen puntos
                print('way:',elemento.ref)
                way = q.get_way(elemento.ref)
                coordenadas_way = [(float(node.lon), float(node.lat)) for node in way.get_nodes()]
                print(coordenadas_way)
                if elemento.role == "outer":
                    print('añadido outer')
                    coordenadas_outer.append(coordenadas_way)
                elif elemento.role == "inner":
                    coordenadas_inners.append(coordenadas_way)
                # vamos quitando los elementos que ya hemos utilizados para que nos se repitan al analizar el caso 2
                del q._ways[elemento.ref]


        if len(coordenadas_outer)>1:  # si es un solo way no hay que hacer nada
            # ordeno el primer way (comparándolo con el último) antes de iterar
            if (coordenadas_outer[0][-1] == coordenadas_outer[-1][0] or coordenadas_outer[0][-1] ==
                    coordenadas_outer[-1][-1]):
                coordenadas_outer[0] = coordenadas_outer[0][::-1]
            for pos in range(len(coordenadas_outer)-1):
                if coordenadas_outer[pos][-1] == coordenadas_outer[pos+1][-1]:  # si el ultimo punto es igual al ultimo del siguiente --> reverse el ultimo
                    coordenadas_outer[pos] = coordenadas_outer[pos][:-1]  # quito el ultimo elemento para que no se repitan
                    coordenadas_outer[pos+1] = coordenadas_outer[pos+1][::-1]  # reverse
            coordenadas_outer = [[item for sublist in coordenadas_outer for item in sublist]]  ####pasar de lista de listas a una sola lista

        # ahora ya puedo juntar las 2 listas
        coordenadas_relation=coordenadas_outer+coordenadas_inners

        # añado a features para poder exportar
        poligono = geojson.Polygon(coordenadas_relation)
        features.append(geojson.Feature(geometry=poligono, properties=relation.tags,
                                        id=relation._type_value+"/"+str(relation.id)))

    # guardo el resultado como geojson
    feature_collection = geojson.FeatureCollection(features)  # necesario para exportar como geojson
    with open('Madrid.geojson'.format(name_file), 'w') as f:
        geojson.dump(feature_collection, f)
                                      



