from A03Functionalities import Functionality 
from C01Common import CommonSql
from random import randint

class Basic_layers(CommonSql):
    def __init__(self,pgconn):
        CommonSql.__init__(self,pgconn)

    def query(self, deleting, typeofingest):
        #typeofingest: 1.fromspainDDBB 2.from geojson
        #get number of features in basic layers
        n_layers= self.query_numberlayers()
    
        #for each:
            #get feature from table -> id
            #get all the types and subtypes with this feature id 
            #execute one_subtype
        vec_total=range(1, n_layers+1)
        vec_interes=[10] 

        for id_f in vec_total:
            
            info= self.query_getInform(id_f)
            if info!=0: 
                name=info[0]
                geom_type_id= info[1]
                prop= [info[4],info[5],info[6],info[7]]
                description_layer=info[8]
                geofence=info[2]
                name_view=name
                doc=name
                new=0
                func= Functionality(self._pgconn)
                #search from the layer with this name
                layer_id=func.get_layerid(name)
                if layer_id==None:
                    #creation of layer if not exists
                    layer_id =func.createlayer(name_view, geom_type_id, description_layer)
                    print('register for layer created')
                    new=1
                
                #delete previous features from this layer
                if deleting:
                    func.delete_layers_features(layer_id)
                
                #get the different types and subtypes for this feature:
                osm_types= self.get_osmtype(id_f)
                #for each type and subtype
                for types in osm_types:
                    class_osm=types[0]
                    doc=types[2]
                    if types[1]!= 'all':
                        subclass_osm=types[1]
                        try:
                            if typeofingest==1:
                                func.one_subtype(doc, class_osm, subclass_osm, prop, self._pgconn, layer_id, geofence,geom_type_id)
                            elif typeofingest==2:
                                func.one_subtype_gjson(doc, class_osm, subclass_osm, prop, self._pgconn, layer_id, geofence,geom_type_id)
                        except Exception as ex :
                            #we have to take into account what can we do when the required query in osm is too higher -> #one option comunidades autonomas
                            print("ERROR: ", type(ex), ex.args)
                            #first thing to do is delete all features inserted for this feature-> think if delete all or only the ones from this type subtype
                            if deleting:
                                func.delete_layers_features(layer_id)
                    else:
                        try:
                            if typeofingest==1:
                                func.one_group(doc, class_osm, prop, self._pgconn, layer_id,geofence,geom_type_id)
                            elif typeofingest==2:
                                func.one_group_gjson(doc, class_osm, prop, self._pgconn, layer_id,geofence,geom_type_id)
                        except Exception as ex :
                            #we have to take into account what can we do when the required query in osm is too higher -> #one option comunidades autonomas
                            print("ERROR: ", type(ex), ex.args)
                            #first thing to do is delete all features inserted for this feature-> think if delete all or only the ones from this type subtype
                            if deleting:
                                func.delete_layers_features(layer_id)

        

    def query_numberlayers(self):

        query=''' SELECT feature_id FROM geofence_basic_layers;'''

        try:
            self._cursor.execute(query)
            layers= self._cursor.fetchall()
            return len(layers)
        except:
            return 0

    def query_getInform(self,id_f):

        query=''' SELECT name, geometry_codification_geometry_type, geofence, buffer, prop1, prop2, prop3, prop4, description_layer
                  FROM geofence_basic_layers 
                  WHERE feature_id={};'''.format(id_f)

        try:
            self._cursor.execute(query)
            info= self._cursor.fetchall()
            return info[0]

        except Exception as ex :
            print("ERROR: ", type(ex), ex.args)
            return 0

    def get_osmtype(self,id_f):

        query= '''SELECT class_osm, subclass_osm, document_name FROM osm_basic_layers WHERE geofence_basic_layers_feature_id='{}';'''.format(id_f)

        try:
            self._cursor.execute(query)
            osmtypes= self._cursor.fetchall()
            return osmtypes
        except Exception as ex :
            print("ERROR: ", type(ex), ex.args)
            return 0
    
    
        
    
            


