from pgConnection import PgConnection
from B02CreateTables import CreateTables
from B03Osm_conetion import OsmConnection
from B01Insert_feature import Feature
from A03Functionalities import Functionality
from A04AddBasicLayers import Basic_layers
from A06DownloadBasicLayers import Basic_layers_Download
from C01Common import CommonSql
import geojson
import os

#1.WE CREATE THE CONNECTION
pgconn = PgConnection()

execCase=1

#3. We download all features for Spain from OSM basic layers:
if execCase==1:
    osmdownload= Basic_layers_Download(pgconn)
    osmdownload.query()
    print('all geojson downloaded')


#4. we add feature from OSM basic layers:
if execCase==2:
    layersosm= Basic_layers(pgconn)
    layersosm.query()
    print('end')


#5. check roads:
if execCase==3:
    c= CommonSql(pgconn)
    query=" SELECT ST_AsEWKT(geom_linestring) FROM features WHERE feature_id='ce611acd-6fe7-47b9-857b-01a44217cf8a';"
    c._cursor.execute(query)
    result= c._cursor.fetchall()
    print('')


#6.We add feature layer
if execCase==4:
    func= Feature(pgconn)
    osmtype='amenity'
    osmsubtype=['university']
    coords=['40.304740', '-4.040336', '40.619906','-3.363406']
    doc='schools_university_amenity'
    properties=['name', 'oneway']
    name='hospital'
    geom_type_id= 3
    description_layer='none'
    name_view=name
    numberFunc=1 #1:one subtype; 2:one group; 3:some subtypes of one group

    func= Functionality(pgconn)

        #6.1 download osm:
    if osmsubtype!=[]:
        for each_osmsubtype in osmsubtype:
            func.one_subtype_osm(doc, osmtype, each_osmsubtype,'esp',coords)
    elif osmsubtype==[]:
        func.one_group_osm(doc, osmtype,'esp',coords)

        #6.2 insert geojson into DDBB:
    layer_id=func.get_layerid(name)
    if layer_id==None:
        #creation of layer if not exists
        layer_id =func.createlayer(name_view, geom_type_id, description_layer)
        print('register for layer created')
    if numberFunc==1:
        for each_osmsubtype in osmsubtype:
            func.one_subtype(doc, osmtype, each_osmsubtype, properties, pgconn,layer_id)
    elif numberFunc==2:
        func.one_group(doc, osmtype, properties, pgconn,layer_id)
    elif numberFunc==3:
        func.some_subtype_1group(doc, osmtype, osmsubtype, properties, pgconn,layer_id)