#TEST to check that all modifications in fusion table are modified on eurocae model:

'''
table geofences:
    sequential_id: it cant be modified
    identifier: varchar 10
    layer_name:if the layer is not in the list, back would create a new layer. the list available is {DenselyPopulatedRegion, power_plant_volume, protected_zone_volume, schools_volume, townhall_volume, natural_zone_volume, hospitals_volume, TemporartFlightRestriction, aerodromes_volume, Emergency, aerodromes_volume, ControlledAirspace, rail_station_volume, SpecialUseAirspace, military_volume, generator_volume}
    geom_buffer: multipolygon
    name_feature: 
    lower_limit
    upper_limit
    lower_vertical_reference: one between AGL AMSL WGS84
    upper_vertical_reference: one between AGL AMSL WGS84
    geom_center: GeometryCollection
    geom_radius: int if negative line buffer if positive, it is the radious of a circle
    active: bool to say if the geofences is active or disactive
    contact: only for osm 
    url: only for osm
    oid: only for osm
    country_id: from ISO 3166-1 alpha 3 
    region
    restriction: json with this structure {"type": "code_restriction_type", "values": [{"restriction_type_name": "REQ_AUTHORISATION"}, {"restriction_type_name": "CONDITIONAL", "conditions": [{"condition_name": "Manual authorization required from XXX"}, {"condition_name": "Allowed Operators/drones", "operators_allowed": [{"operator_id": "1", "drones_allowed": [{"drone_id": "1"}]}]}]}]}
    code_zone_reason: json with this structure {"type": "code_zone_reason", "values": [{"code_zone_type_name": "Population"}, {"code_zone_type_name": "Nature"}, {"code_zone_type_name": "Noise"}]}
    code_uspace_class_type: json with this structure {"type": "code_uspace_class_type", "values": [{"uspace_class_type_name": "NDZ"}, {"uspace_class_type_name": "EDZp"}, {"uspace_class_type_name": "EDZm"}]}
    volume_limitations: json with this structure {"type": "volume_limitation", "values": [{"volume_limitation_name": "Certification Type 0"}, {"volume_limitation_name": "Certification Type 3"}, {"volume_limitation_name": "Operation_type Specific"}]}
    code_zone_type: one between this list {COMMON, CUSTOMIZED, MODIFIED}
    time_period: json with this structure {"type": "time_period", "values": [{"start_date": "01-Jan-2000 ", "end_date": "01-Dec-2050 ", "permanent": true, "daily_periods": [{"start_time": "01-Jan-1900 (09:00:00.000000)", "end_time": "01-Jan-1900 (15:00:00.000000)", "week_day": "Fryday"}]}]}
    message: 
    data_capture_prohibition: bool
    author_metadata
    intervalbefore: varchar 11
    remote_id: cant be modified directly, it has to be done by restriction property
    geoawareness_required: cant be modified directly, it has to be done by restriction property
    creation_datatime
    update_datetime
    authorityfrom: json with the structure   {"type": "authorityfrom", "name": "name of authority", 'service', "authority.service", 'contact_name', "authority.contact_name", 'site_url', "authority.site_url", 'email', "authority.email", 'phone', "authority.phone" }
    notificationto: json with this structure {"type": "notificationto", "name": "name of authority", 'service', "authority.service", 'contact_name', "authority.contact_name", 'site_url', "authority.site_url", 'email', "authority.email", 'phone', "authority.phone" }
'''
from pgConnection import PgConnection
import os
import datetime
import time

#0. CONECTION:
database="newgis"
pgconn = PgConnection(database)

for i in range(1,30):
    execCase=i
    if(execCase==1):
        prop='identifier'
        print('''Test {}:'''.format(prop))
        value='example'
        sid=5
        print('change property {} to {} for sequential_id {}'.format(prop,value,sid))
        query= '''UPDATE geofences SET {} = '{}' WHERE sequential_id={}'''.format(prop,value,sid)
        try:
            ts = time.time()
            pgconn.cursor.execute(query)
            pgconn.connection.commit()
            te = time.time()
            timeexec=round(te - ts, 5)
        except Exception as ex :
            print("ERROR: ", type(ex), ex.args)

        queryselect= '''SELECT {} FROM uas_zone_version WHERE airspace_volume_vol_id IN (SELECT vol_id FROM airspace_volume WHERE sequential_id={});'''.format(prop,sid)
        try: 
            pgconn.cursor.execute(queryselect)
            results=pgconn.cursor.fetchall()
        except Exception as ex :
            print("ERROR: ", type(ex), ex.args)

        print('Test {}: value inserted {} and value returned {}. TEST SUCCESSFULLY: {} in {} ms'.format(prop,value,results[0][0],value==results[0][0], timeexec*1000))

    if(execCase==2):
        prop='layer_name'
        value='schools_volume'
        sid=5
        print('Test {}:'.format(prop))
        print('change property {} to {} for sequential_id {}'.format(prop,value,sid))
        query= '''UPDATE geofences SET {} = '{}' WHERE sequential_id={}'''.format(prop,value,sid)
        try:
            ts = time.time()
            pgconn.cursor.execute(query)
            pgconn.connection.commit()
            te = time.time()
            timeexec=round(te - ts, 5)
        except Exception as ex :
            print("ERROR: ", type(ex), ex.args)

        queryselect= '''SELECT name FROM layers_volume WHERE layer_id IN (SELECT layers_layer_id FROM airspace_volume WHERE sequential_id={});'''.format(sid)
        try: 
            pgconn.cursor.execute(queryselect)
            results=pgconn.cursor.fetchall()
        except Exception as ex :
            print("ERROR: ", type(ex), ex.args)

        print('Test {}: value inserted {} and value returned {}. TEST SUCCESSFULLY: {} in {} ms'.format(prop,value,results[0][0],value==results[0][0], timeexec*1000))

    if(execCase==3):
        prop='geom_buffer'
        value='MULTIPOLYGON(((-2.8001205514147 37.8923252965836,-2.67564686446385 37.9656428983705,-2.72231818391457 37.8916144355108,-2.72428122429462 37.8879845103478, -2.70226559709314 37.8605123144506,-2.8001205514147 37.8923252965836)))'
        sid=5
        print('Test {}:'.format(prop))
        print('change property {} to {} for sequential_id {}'.format(prop,value,sid))
        query= '''UPDATE geofences SET {} = ST_GeomFromText(ST_AsEWKT(ST_GeomFromText('{}',4326)::geography)) WHERE sequential_id={}'''.format(prop,value,sid)
        try:
            ts = time.time()
            pgconn.cursor.execute(query)
            pgconn.connection.commit()
            te = time.time()
            timeexec=round(te - ts, 5)
        except Exception as ex :
            print("ERROR: ", type(ex), ex.args)

        queryselect= '''SELECT ST_AsText(geom_buffer) FROM airspace_volume WHERE sequential_id={};'''.format(sid)
        try: 
            pgconn.cursor.execute(queryselect)
            results=pgconn.cursor.fetchall()
        except Exception as ex :
            print("ERROR: ", type(ex), ex.args)

        print('Test {}: value inserted {} and value returned {}. TEST SUCCESSFULLY: {} in {} ms'.format(prop,value,results[0][0],value==results[0][0], timeexec*1000))
        
    if(execCase==4):
        prop='name_feature'
        value='example change name'
        sid=5
        print('Test {}:'.format(prop))
        print('change property {} to {} for sequential_id {}'.format(prop,value,sid))
        query= '''UPDATE geofences SET {} = '{}' WHERE sequential_id={}'''.format(prop,value,sid)
        try:
            ts = time.time()
            pgconn.cursor.execute(query)
            pgconn.connection.commit()
            te = time.time()
            timeexec=round(te - ts, 5)
        except Exception as ex :
            print("ERROR: ", type(ex), ex.args)

        queryselect= '''SELECT name FROM uas_zone_version WHERE airspace_volume_vol_id IN (SELECT vol_id FROM airspace_volume WHERE sequential_id={});'''.format(sid)
        try: 
            pgconn.cursor.execute(queryselect)
            results=pgconn.cursor.fetchall()
        except Exception as ex :
            print("ERROR: ", type(ex), ex.args)

        print('Test {}: value inserted {} and value returned {}. TEST SUCCESSFULLY: {} in {} ms'.format(prop,value,results[0][0],value==results[0][0], timeexec*1000))
        
    if(execCase==5):
        prop='lower_limit'
        value=100
        sid=5
        print('Test {}:'.format(prop))
        print('change property {} to {} for sequential_id {}'.format(prop,value,sid))
        query= '''UPDATE geofences SET {} = {} WHERE sequential_id={}'''.format(prop,value,sid)
        try:
            ts = time.time()
            pgconn.cursor.execute(query)
            pgconn.connection.commit()
            te = time.time()
            timeexec=round(te - ts, 5)
        except Exception as ex :
            print("ERROR: ", type(ex), ex.args)

        queryselect= '''SELECT lower_limit FROM airspace_volume  WHERE sequential_id={};'''.format(sid)
        try: 
            pgconn.cursor.execute(queryselect)
            results=pgconn.cursor.fetchall()
        except Exception as ex :
            print("ERROR: ", type(ex), ex.args)

        print('Test {}: value inserted {} and value returned {}. TEST SUCCESSFULLY: {} in {} ms'.format(prop,value,results[0][0],value==results[0][0], timeexec*1000))
        
    if(execCase==6):
        prop='upper_limit'
        value=100
        sid=5
        print('Test {}:'.format(prop))
        print('change property {} to {} for sequential_id {}'.format(prop,value,sid))
        query= '''UPDATE geofences SET {} = {} WHERE sequential_id={}'''.format(prop,value,sid)
        try:
            ts = time.time()
            pgconn.cursor.execute(query)
            pgconn.connection.commit()
            te = time.time()
            timeexec=round(te - ts, 5)
        except Exception as ex :
            print("ERROR: ", type(ex), ex.args)

        queryselect= '''SELECT upper_limit FROM airspace_volume  WHERE sequential_id={};'''.format(sid)
        try: 
            pgconn.cursor.execute(queryselect)
            results=pgconn.cursor.fetchall()
        except Exception as ex :
            print("ERROR: ", type(ex), ex.args)

        print('Test {}: value inserted {} and value returned {}. TEST SUCCESSFULLY: {} in {} ms'.format(prop,value,results[0][0],value==results[0][0], timeexec*1000))
        
    if(execCase==7):
        prop='lower_vertical_reference'
        value='AMSL'
        sid=5
        print('Test {}:'.format(prop))
        print('change property {} to {} for sequential_id {}'.format(prop,value,sid))
        query= '''UPDATE geofences SET {} = '{}' WHERE sequential_id={}'''.format(prop,value,sid)
        try:
            ts = time.time()
            pgconn.cursor.execute(query)
            pgconn.connection.commit()
            te = time.time()
            timeexec=round(te - ts, 5)
        except Exception as ex :
            print("ERROR: ", type(ex), ex.args)

        queryselect= '''SELECT name FROM code_vertical_reference WHERE vertical_reference_code IN (SELECT lower_vertical_reference FROM airspace_volume  WHERE sequential_id={});'''.format(sid)
        try: 
            pgconn.cursor.execute(queryselect)
            results=pgconn.cursor.fetchall()
        except Exception as ex :
            print("ERROR: ", type(ex), ex.args)

        print('Test {}: value inserted {} and value returned {}. TEST SUCCESSFULLY: {} in {} ms'.format(prop,value,results[0][0],value==results[0][0], timeexec*1000))
        
    if(execCase==8):
        prop='upper_vertical_reference'
        value='AMSL'
        sid=5
        print('Test {}:'.format(prop))
        print('change property {} to {} for sequential_id {}'.format(prop,value,sid))
        query= '''UPDATE geofences SET {} = '{}' WHERE sequential_id={}'''.format(prop,value,sid)
        try:
            ts = time.time()
            pgconn.cursor.execute(query)
            pgconn.connection.commit()
            te = time.time()
            timeexec=round(te - ts, 5)
        except Exception as ex :
            print("ERROR: ", type(ex), ex.args)

        queryselect= '''SELECT name FROM code_vertical_reference WHERE vertical_reference_code IN (SELECT upper_vertical_reference FROM airspace_volume  WHERE sequential_id={});'''.format(sid)
        try: 
            pgconn.cursor.execute(queryselect)
            results=pgconn.cursor.fetchall()
        except Exception as ex :
            print("ERROR: ", type(ex), ex.args)

        print('Test {}: value inserted {} and value returned {}. TEST SUCCESSFULLY: {} in {} ms'.format(prop,value,results[0][0],value==results[0][0], timeexec*1000))
        
    if(execCase==9):
        prop='geom_center'
        value='GEOMETRYCOLLECTION(POINT(-1.15020589261845 38.4472871307411))'
        sid=5
        print('Test {}:'.format(prop))
        print('change property {} to {} for sequential_id {}'.format(prop,value,sid))
        query= '''UPDATE geofences SET {} = ST_GeomFromText(ST_AsEWKT(ST_GeomFromText('{}',4326)::geography)) WHERE sequential_id={}'''.format(prop,value,sid)
        try:
            ts = time.time()
            pgconn.cursor.execute(query)
            pgconn.connection.commit()
            te = time.time()
            timeexec=round(te - ts, 5)
        except Exception as ex :
            print("ERROR: ", type(ex), ex.args)

        queryselect= '''SELECT ST_AsText(geom_center) FROM airspace_volume  WHERE sequential_id={};'''.format(sid)
        try: 
            pgconn.cursor.execute(queryselect)
            results=pgconn.cursor.fetchall()
        except Exception as ex :
            print("ERROR: ", type(ex), ex.args)

        print('Test {}: value inserted {} and value returned {}. TEST SUCCESSFULLY: {} in {} ms'.format(prop,value,results[0][0],value==results[0][0], timeexec*1000))
        
    if(execCase==10):
        prop='geom_radius'
        value=30
        sid=5
        print('Test {}:'.format(prop))
        print('change property {} to {} for sequential_id {}'.format(prop,value,sid))
        query= '''UPDATE geofences SET {} = {} WHERE sequential_id={}'''.format(prop,value,sid)
        try:
            ts = time.time()
            pgconn.cursor.execute(query)
            pgconn.connection.commit()
            te = time.time()
            timeexec=round(te - ts, 5)
        except Exception as ex :
            print("ERROR: ", type(ex), ex.args)

        queryselect= '''SELECT geom_radius FROM airspace_volume  WHERE sequential_id={};'''.format(sid)
        try: 
            pgconn.cursor.execute(queryselect)
            results=pgconn.cursor.fetchall()
        except Exception as ex :
            print("ERROR: ", type(ex), ex.args)

        print('Test {}: value inserted {} and value returned {}. TEST SUCCESSFULLY: {} in {} ms'.format(prop,value,results[0][0],value==results[0][0], timeexec*1000))
       
    if(execCase==11):
        prop='contact'
        value= 'example'
        sid=5
        print('Test {}:'.format(prop))
        print('change property {} to {} for sequential_id {}'.format(prop,value,sid))
        query= '''UPDATE geofences SET {} = '{}' WHERE sequential_id={}'''.format(prop,value,sid)
        try:
            ts = time.time()
            pgconn.cursor.execute(query)
            pgconn.connection.commit()
            te = time.time()
            timeexec=round(te - ts, 5)
        except Exception as ex :
            print("ERROR: ", type(ex), ex.args)

        queryselect= '''SELECT prop2_value FROM features WHERE feature_id IN (SELECT geom_origin FROM airspace_volume WHERE sequential_id={})'''.format(sid)
        try: 
            pgconn.cursor.execute(queryselect)
            results=pgconn.cursor.fetchall()
        except Exception as ex :
            print("ERROR: ", type(ex), ex.args)

        print('Test {}: value inserted {} and value returned {}. TEST SUCCESSFULLY: {} in {} ms'.format(prop,value,results[0][0],value==results[0][0], timeexec*1000))
        
    if(execCase==12):
        prop='url'
        value= 'example'
        sid=5
        print('Test {}:'.format(prop))
        print('change property {} to {} for sequential_id {}'.format(prop,value,sid))
        query= '''UPDATE geofences SET {} = '{}' WHERE sequential_id={}'''.format(prop,value,sid)
        try:
            ts = time.time()
            pgconn.cursor.execute(query)
            pgconn.connection.commit()
            te = time.time()
            timeexec=round(te - ts, 5)
        except Exception as ex :
            print("ERROR: ", type(ex), ex.args)

        queryselect= '''SELECT prop3_value FROM features WHERE feature_id IN (SELECT geom_origin FROM airspace_volume WHERE sequential_id={});'''.format(sid)
        try: 
            pgconn.cursor.execute(queryselect)
            results=pgconn.cursor.fetchall()
        except Exception as ex :
            print("ERROR: ", type(ex), ex.args)

        print('Test {}: value inserted {} and value returned {}. TEST SUCCESSFULLY: {} in {} ms'.format(prop,value,results[0][0],value==results[0][0], timeexec*1000))
        
    if(execCase==13):
        prop='oid'
        value= 'example'
        sid=5
        print('Test {}:'.format(prop))
        print('change property {} to {} for sequential_id {}'.format(prop,value,sid))
        query= '''UPDATE geofences SET {} = '{}' WHERE sequential_id={}'''.format(prop,value,sid)
        try:
            ts = time.time()
            pgconn.cursor.execute(query)
            pgconn.connection.commit()
            te = time.time()
            timeexec=round(te - ts, 5)
        except Exception as ex :
            print("ERROR: ", type(ex), ex.args)

        queryselect= '''SELECT prop4_value FROM features WHERE feature_id IN (SELECT geom_origin FROM airspace_volume WHERE sequential_id={});'''.format(sid)
        try: 
            pgconn.cursor.execute(queryselect)
            results=pgconn.cursor.fetchall()
        except Exception as ex :
            print("ERROR: ", type(ex), ex.args)

        print('Test {}: value inserted {} and value returned {}. TEST SUCCESSFULLY: {} in {} ms'.format(prop,value,results[0][0],value==results[0][0], timeexec*1000))
        
    if(execCase==14):
        prop='country_id'
        value= 'FRA'
        sid=5
        print('Test {}:'.format(prop))
        print('change property {} to {} for sequential_id {}'.format(prop,value,sid))
        query= '''UPDATE geofences SET {} = '{}' WHERE sequential_id={}'''.format(prop,value,sid)
        try:
            ts = time.time()
            pgconn.cursor.execute(query)
            pgconn.connection.commit()
            te = time.time()
            timeexec=round(te - ts, 5)
        except Exception as ex :
            print("ERROR: ", type(ex), ex.args)

        queryselect= '''SELECT country_id FROM uas_zone_version WHERE airspace_volume_vol_id IN (SELECT vol_id FROM airspace_volume WHERE sequential_id={});'''.format(sid)
        try: 
            pgconn.cursor.execute(queryselect)
            results=pgconn.cursor.fetchall()
        except Exception as ex :
            print("ERROR: ", type(ex), ex.args)

        print('Test {}: value inserted {} and value returned {}. TEST SUCCESSFULLY: {} in {} ms'.format(prop,value,results[0][0],value==results[0][0], timeexec*1000))
        
    if(execCase==15):
        prop='region'
        value= 2
        sid=5
        print('Test {}:'.format(prop))
        print('change property {} to {} for sequential_id {}'.format(prop,value,sid))
        query= '''UPDATE geofences SET {} = {} WHERE sequential_id={}'''.format(prop,value,sid)
        try:
            ts = time.time()
            pgconn.cursor.execute(query)
            pgconn.connection.commit()
            te = time.time()
            timeexec=round(te - ts, 5)
        except Exception as ex :
            print("ERROR: ", type(ex), ex.args)

        queryselect= '''SELECT region FROM uas_zone_version WHERE airspace_volume_vol_id IN (SELECT vol_id FROM airspace_volume WHERE sequential_id={});'''.format(sid)
        try: 
            pgconn.cursor.execute(queryselect)
            results=pgconn.cursor.fetchall()
        except Exception as ex :
            print("ERROR: ", type(ex), ex.args)

        print('Test {}: value inserted {} and value returned {}. TEST SUCCESSFULLY: {} in {} ms'.format(prop,value,results[0][0],value==results[0][0], timeexec*1000))
        
    if(execCase==16):
        prop='restriction'
        value= '{"type": "code_restriction_type", "values": [{"restriction_type_name": "REQ_AUTHORISATION"}, {"restriction_type_name": "CONDITIONAL", "conditions": [{"condition_name": "Manual authorization required from XXX"}, {"condition_name": "Allowed Operators/drones"}]}]}'
        sid=5
        print('Test {}:'.format(prop))
        print('change property {} to {} for sequential_id {}'.format(prop,value,sid))
        query= '''UPDATE geofences SET {} = encode(convert_to('{}', 'UTF-8'),'base64') WHERE sequential_id={}'''.format(prop,value,sid)
        try:
            ts = time.time()
            pgconn.cursor.execute(query)
            pgconn.connection.commit()
            te = time.time()
            timeexec=round(te - ts, 5)
        except Exception as ex :
            print("ERROR: ", type(ex), ex.args)

        queryselect= '''SELECT name FROM code_restriction_type WHERE restriction_code IN (SELECT code_restriction_type_restriction_code FROM uas_code_restriction_type WHERE uas_zone_version_uas_zone_id IN (SELECT uas_zone_id FROM uas_zone_version WHERE airspace_volume_vol_id IN (SELECT vol_id FROM airspace_volume WHERE sequential_id={})));'''.format(sid)
        try: 
            pgconn.cursor.execute(queryselect)
            results=pgconn.cursor.fetchall()
        except Exception as ex :
            print("ERROR: ", type(ex), ex.args)

        print('Test {}: value inserted {} and value returned {} in {} ms'.format(prop,value,results, timeexec*1000))

    if(execCase==17):
        prop='code_zone_reason'
        value= '{"type": "code_zone_reason", "values": [{"code_zone_type_name": "Population"}, {"code_zone_type_name": "Nature"}, {"code_zone_type_name": "Noise"}]}'
        sid=5
        print('Test {}:'.format(prop))
        print('change property {} to {} for sequential_id {}'.format(prop,value,sid))
        query= '''UPDATE geofences SET {} = encode(convert_to('{}', 'UTF-8'),'base64') WHERE sequential_id={}'''.format(prop,value,sid)
        try:
            ts = time.time()
            pgconn.cursor.execute(query)
            pgconn.connection.commit()
            te = time.time()
            timeexec=round(te - ts, 5)
        except Exception as ex :
            print("ERROR: ", type(ex), ex.args)

        queryselect= '''SELECT name FROM code_zone_reason WHERE code_zone_reason IN (SELECT code_zone_reason_code_zone_reason FROM uas_code_zone_reason WHERE uas_zone_version_uas_zone_id IN (SELECT uas_zone_id FROM uas_zone_version WHERE airspace_volume_vol_id IN (SELECT vol_id FROM airspace_volume WHERE sequential_id={})));'''.format(sid)
        try: 
            pgconn.cursor.execute(queryselect)
            results=pgconn.cursor.fetchall()
        except Exception as ex :
            print("ERROR: ", type(ex), ex.args)

        print('Test {}: value inserted {} and value returned {} in {} ms'.format(prop,value,results, timeexec*1000))

    if(execCase==18):
        prop='code_uspace_class_type'
        value= '{"type": "code_uspace_class_type", "values": [{"uspace_class_type_name": "NDZ"}, {"uspace_class_type_name": "EDZp"}, {"uspace_class_type_name": "EDZm"}]}'
        sid=5
        print('Test {}:'.format(prop))
        print('change property {} to {} for sequential_id {}'.format(prop,value,sid))
        query= '''UPDATE geofences SET {} = encode(convert_to('{}', 'UTF-8'),'base64') WHERE sequential_id={}'''.format(prop,value,sid)
        try:
            ts = time.time()
            pgconn.cursor.execute(query)
            pgconn.connection.commit()
            te = time.time()
            timeexec=round(te - ts, 5)
        except Exception as ex :
            print("ERROR: ", type(ex), ex.args)

        queryselect= '''SELECT name FROM code_uspace_class_type WHERE u_space_code IN (SELECT code_uspace_class_type_u_space_code FROM uas_code_uspace_class_type WHERE uas_zone_version_uas_zone_id IN (SELECT uas_zone_id FROM uas_zone_version WHERE airspace_volume_vol_id IN (SELECT vol_id FROM airspace_volume WHERE sequential_id={})));'''.format(sid)
        try: 
            pgconn.cursor.execute(queryselect)
            results=pgconn.cursor.fetchall()
        except Exception as ex :
            print("ERROR: ", type(ex), ex.args)

        print('Test {}: value inserted {} and value returned {} in {} ms'.format(prop,value,results, timeexec*1000))

    if(execCase==19):
        prop='volume_limitations'
        value= '{"type": "volume_limitation", "values": [{"volume_limitation_name": "Certification Type 0"}, {"volume_limitation_name": "Certification Type 3"}, {"volume_limitation_name": "Operation_type Specific"}]}'
        sid=5
        print('Test {}:'.format(prop))
        print('change property {} to {} for sequential_id {}'.format(prop,value,sid))
        query= '''UPDATE geofences SET {} = encode(convert_to('{}', 'UTF-8'),'base64') WHERE sequential_id={}'''.format(prop,value,sid)
        try:
            ts = time.time()
            pgconn.cursor.execute(query)
            pgconn.connection.commit()
            te = time.time()
            timeexec=round(te - ts, 5)
        except Exception as ex :
            print("ERROR: ", type(ex), ex.args)

        queryselect= '''SELECT name_code FROM volume_limitation_definitions WHERE limitation_definition_id IN (SELECT volume_limitation_definitions_limitation_definition_id FROM volume_limitation WHERE uas_zone_version_uas_zone_id IN (SELECT uas_zone_id FROM uas_zone_version WHERE airspace_volume_vol_id IN (SELECT vol_id FROM airspace_volume WHERE sequential_id={})));'''.format(sid)
        try: 
            pgconn.cursor.execute(queryselect)
            results=pgconn.cursor.fetchall()
        except Exception as ex :
            print("ERROR: ", type(ex), ex.args)

        print('Test {}: value inserted {} and value returned {} in {} ms'.format(prop,value,results, timeexec*1000))

    if(execCase==20):
        prop='code_zone_type'
        value= 'CUSTOMIZED'
        sid=5
        print('Test {}:'.format(prop))
        print('change property {} to {} for sequential_id {}'.format(prop,value,sid))
        query= '''UPDATE geofences SET {} = '{}' WHERE sequential_id={}'''.format(prop,value,sid)
        try:
            ts = time.time()
            pgconn.cursor.execute(query)
            pgconn.connection.commit()
            te = time.time()
            timeexec=round(te - ts, 5)
        except Exception as ex :
            print("ERROR: ", type(ex), ex.args)

        queryselect= '''SELECT name FROM code_zone_type WHERE type_code IN (SELECT code_zone_type_type_code FROM uas_zone_version WHERE airspace_volume_vol_id IN (SELECT vol_id FROM airspace_volume WHERE sequential_id={}));'''.format(sid)
        try: 
            pgconn.cursor.execute(queryselect)
            results=pgconn.cursor.fetchall()
        except Exception as ex :
            print("ERROR: ", type(ex), ex.args)

        print('Test {}: value inserted {} and value returned {}. TEST SUCCESSFULLY: {} in {} ms'.format(prop,value,results[0][0],value==results[0][0], timeexec*1000))
        
    if(execCase==21):
        prop='message'
        value='example change message'
        sid=5
        print('Test {}:'.format(prop))
        print('change property {} to {} for sequential_id {}'.format(prop,value,sid))
        query= '''UPDATE geofences SET {} = '{}' WHERE sequential_id={}'''.format(prop,value,sid)
        try:
            ts = time.time()
            pgconn.cursor.execute(query)
            pgconn.connection.commit()
            te = time.time()
            timeexec=round(te - ts, 5)
        except Exception as ex :
            print("ERROR: ", type(ex), ex.args)

        queryselect= '''SELECT message FROM uas_zone_version WHERE airspace_volume_vol_id IN (SELECT vol_id FROM airspace_volume WHERE sequential_id={});'''.format(sid)
        try: 
            pgconn.cursor.execute(queryselect)
            results=pgconn.cursor.fetchall()
        except Exception as ex :
            print("ERROR: ", type(ex), ex.args)

        print('Test {}: value inserted {} and value returned {}. TEST SUCCESSFULLY: {} in {} ms'.format(prop,value,results[0][0],value==results[0][0], timeexec*1000))
        
    if(execCase==22):
        prop='data_capture_prohibition'
        value='True'
        sid=5
        print('Test {}:'.format(prop))
        print('change property {} to {} for sequential_id {}'.format(prop,value,sid))
        query= '''UPDATE geofences SET {} = {} WHERE sequential_id={}'''.format(prop,value,sid)
        try:
            ts = time.time()
            pgconn.cursor.execute(query)
            pgconn.connection.commit()
            te = time.time()
            timeexec=round(te - ts, 5)
        except Exception as ex :
            print("ERROR: ", type(ex), ex.args)

        queryselect= '''SELECT data_capture_prohibition FROM uas_zone_version WHERE airspace_volume_vol_id IN (SELECT vol_id FROM airspace_volume WHERE sequential_id={});'''.format(sid)
        try: 
            pgconn.cursor.execute(queryselect)
            results=pgconn.cursor.fetchall()
        except Exception as ex :
            print("ERROR: ", type(ex), ex.args)

        print('Test {}: value inserted {} and value returned {}. TEST SUCCESSFULLY: {} in {} ms'.format(prop,value,results[0][0],value==results[0][0], timeexec*1000))
        
    if(execCase==23):
        prop='author_metadata'
        value='author changed'
        sid=5
        print('Test {}:'.format(prop))
        print('change property {} to {} for sequential_id {}'.format(prop,value,sid))
        query= '''UPDATE geofences SET {} = '{}' WHERE sequential_id={}'''.format(prop,value,sid)
        try:
            ts = time.time()
            pgconn.cursor.execute(query)
            pgconn.connection.commit()
            te = time.time()
            timeexec=round(te - ts, 5)
        except Exception as ex :
            print("ERROR: ", type(ex), ex.args)

        queryselect= '''SELECT author FROM metadata WHERE metada_id IN (SELECT metadata_metada_id FROM uas_zone_version WHERE airspace_volume_vol_id IN (SELECT vol_id FROM airspace_volume WHERE sequential_id={}));'''.format(sid)
        try: 
            pgconn.cursor.execute(queryselect)
            results=pgconn.cursor.fetchall()
        except Exception as ex :
            print("ERROR: ", type(ex), ex.args)

        print('Test {}: value inserted {} and value returned {}. TEST SUCCESSFULLY: {} in {} ms'.format(prop, value,results[0][0],value==results[0][0], timeexec*1000))
        
    if(execCase==24):
        prop='intervalbefore'
        value='ljgh'
        sid=5
        print('Test {}:'.format(prop))
        print('change property {} to {} for sequential_id {}'.format(prop,value,sid))
        query= '''UPDATE geofences SET {} = '{}' WHERE sequential_id={}'''.format(prop,value,sid)
        try:
            ts = time.time()
            pgconn.cursor.execute(query)
            pgconn.connection.commit()
            te = time.time()
            timeexec=round(te - ts, 5)
        except Exception as ex :
            print("ERROR: ", type(ex), ex.args)

        queryselect= '''SELECT intervalbefore FROM uas_zone_version WHERE airspace_volume_vol_id IN (SELECT vol_id FROM airspace_volume WHERE sequential_id={});'''.format(sid)
        try: 
            pgconn.cursor.execute(queryselect)
            results=pgconn.cursor.fetchall()
        except Exception as ex :
            print("ERROR: ", type(ex), ex.args)

        print('Test {}: value inserted {} and value returned {}. TEST SUCCESSFULLY: {} in {} ms'.format(prop,value,results[0][0],value==results[0][0], timeexec*1000))
        
    if(execCase==25):
        prop='creation_datetime'
        value='2021-06-26 00:00:00+01'
        sid=5
        print('Test {}:'.format(prop))
        print('change property {} to {} for sequential_id {}'.format(prop,value,sid))
        query= '''UPDATE geofences SET {} = '{}' WHERE sequential_id={}'''.format(prop,value,sid)
        try:
            ts = time.time()
            pgconn.cursor.execute(query)
            pgconn.connection.commit()
            te = time.time()
            timeexec=round(te - ts, 5)
        except Exception as ex :
            print("ERROR: ", type(ex), ex.args)

        queryselect= '''SELECT creation_date_time FROM metadata WHERE metada_id IN(SELECT metadata_metada_id FROM uas_zone_version WHERE airspace_volume_vol_id IN (SELECT vol_id FROM airspace_volume WHERE sequential_id={}));'''.format(sid)
        try: 
            pgconn.cursor.execute(queryselect)
            results=pgconn.cursor.fetchall()
        except Exception as ex :
            print("ERROR: ", type(ex), ex.args)

        print('Test {}: value inserted {} and value returned {}. TEST SUCCESSFULLY: {} in {} ms'.format(prop,value,results[0][0],value==results[0][0], timeexec*1000))
        
    if(execCase==26):
        prop='authorityfrom'
        value='{"type": "authorityfrom", "name": "name of authority", "service": "exampleservice", "contact_name": "examplecontact_name", "site_url": "https://es.wikipedia.org/wiki/ISO_3166-1", "email": "email@email.com", "phone": "789456123" }'
        sid=5
        print('Test {}:'.format(prop))
        print('change property {} to {} for sequential_id {}'.format(prop,value,sid))
        query= '''UPDATE geofences SET {} =  encode(convert_to('{}', 'UTF-8'),'base64') WHERE sequential_id={}'''.format(prop,value,sid)
        try:
            ts = time.time()
            pgconn.cursor.execute(query)
            pgconn.connection.commit()
            te = time.time()
            timeexec=round(te - ts, 5)
        except Exception as ex :
            print("ERROR: ", type(ex), ex.args)

        queryselect= '''SELECT name, service, contact_name, site_url, email, phone FROM authority WHERE authority_oid IN (SELECT authority_authorityfrom_oid FROM uas_zone_version WHERE airspace_volume_vol_id IN (SELECT vol_id FROM airspace_volume WHERE sequential_id={}));'''.format(sid)
        try: 
            pgconn.cursor.execute(queryselect)
            results=pgconn.cursor.fetchall()
        except Exception as ex :
            print("ERROR: ", type(ex), ex.args)

        print('Test {}: value inserted {} and value returned {}. in {} ms'.format(prop,value,results, timeexec*1000))

    if(execCase==27):
        prop='notificationto'
        value='{"type": "notificationto", "name": "name of authority", "service": "exampleservice", "contact_name": "examplecontact_name", "site_url": "https://es.wikipedia.org/wiki/ISO_3166-1", "email": "email@email.com", "phone": "789456123" }'
        sid=5
        print('Test {}:'.format(prop))
        print('change property {} to {} for sequential_id {}'.format(prop,value,sid))
        query= '''UPDATE geofences SET {} = encode(convert_to('{}', 'UTF-8'),'base64') WHERE sequential_id={}'''.format(prop,value,sid)
        try:
            ts = time.time()
            pgconn.cursor.execute(query)
            pgconn.connection.commit()
            te = time.time()
            timeexec=round(te - ts, 5)
        except Exception as ex :
            print("ERROR: ", type(ex), ex.args)

        queryselect= '''SELECT name, service, contact_name, site_url, email, phone FROM authority WHERE authority_oid IN (SELECT authority_notificationto_oid FROM uas_zone_version WHERE airspace_volume_vol_id IN (SELECT vol_id FROM airspace_volume WHERE sequential_id={}));'''.format(sid)
        try: 
            pgconn.cursor.execute(queryselect)
            results=pgconn.cursor.fetchall()
        except Exception as ex :
            print("ERROR: ", type(ex), ex.args)

        print('Test {}: value inserted {} and value returned {}. in {} ms'.format(prop,value,results, timeexec*1000))

    if(execCase==28):
        prop='time_period'
        value='{"type": "time_period", "values": [{"start_date": "2020-06-20 00:00:00+01", "end_date": "2055-06-26 00:00:00+01 ", "permanent": true, "daily_periods": [{"start_time": "12:00:00+01", "end_time": "12:00:00+01", "week_day": "Fryday"}]}]}'
        sid=5
        print('Test {}:'.format(prop))
        print('change property {} to {} for sequential_id {}'.format(prop,value,sid))
        query= '''UPDATE geofences SET {} = encode(convert_to('{}', 'UTF-8'),'base64') WHERE sequential_id={}'''.format(prop,value,sid)
        try:
            ts = time.time()
            pgconn.cursor.execute(query)
            pgconn.connection.commit()
            te = time.time()
            timeexec=round(te - ts, 5)
        except Exception as ex :
            print("ERROR: ", type(ex), ex.args)

        queryselect= '''SELECT time_period_time_period_id FROM uas_time_period WHERE uas_zone_version_uas_zone_id IN (SELECT uas_zone_id FROM uas_zone_version WHERE airspace_volume_vol_id IN (SELECT vol_id FROM airspace_volume WHERE sequential_id={}));'''.format(sid)
        try: 
            pgconn.cursor.execute(queryselect)
            results=pgconn.cursor.fetchall()
        except Exception as ex :
            print("ERROR: ", type(ex), ex.args)

        print('Test {}: value inserted {} and value returned {}. in {} ms'.format(prop,value,results, timeexec*1000))

    if(execCase==29):
        prop='active'
        value='False'
        sid=5
        print('Test {}:'.format(prop))
        print('change property {} to {} for sequential_id {}'.format(prop,value,sid))
        query= '''UPDATE geofences SET {} = '{}' WHERE sequential_id={}'''.format(prop,value,sid)
        try:
            ts = time.time()
            pgconn.cursor.execute(query)
            pgconn.connection.commit()
            te = time.time()
            timeexec=round(te - ts, 5)
        except Exception as ex :
            print("ERROR: ", type(ex), ex.args)

        queryselect= '''SELECT active FROM airspace_volume WHERE sequential_id={};'''.format(sid)
        try: 
            pgconn.cursor.execute(queryselect)
            results=pgconn.cursor.fetchall()
        except Exception as ex :
            print("ERROR: ", type(ex), ex.args)

        print('Test {}: value inserted {} and value returned {}. in {} ms'.format(prop,value,results, timeexec*1000))